*
* TDBS Enhanced Text Reading Utility
* Revision 1.00
* Written by Alan D. Bryant
* for eSoft, Inc.
*
****************************************************************************
* This program source is included with your TDBS to illustrate techniques. *
* You may use any or all of the source or techniques illustrated in this   *
* program in any fashion you wish.  There are no fees or restrictions      *
* imposed on the use of this code by eSoft, Inc.                           *
****************************************************************************
*
* PURPOSE:  This program can be used as an enhancement to TBBS' internal
* Type 1 menu command.  It is designed to display a text file to the
* screen one page at a time, allow forward and backward movement in the
* file, and download ability on the file.  It also displays a UNIX-like
* "percent complete" measurement.
*
* WARNING:  This program is valid for ANSI users only!
*
* CONCEPTS ILLUSTRATED:  The program illustrates the use of the text
* file I/O system in TDBS 1.2.  It also shows dynamic creation and use
* of a database, which in this case is used to track offsets in the
* text file for backward and forward movement.
*
* FLOW:  The general flow of the program is to read a text file one
* page at a time, offering a pause line at the bottom of each page
* allowing users to move forward, backward, or to download the file.
* offsets are stored to the temp database so that the program can
* find its way back and forth.
*
* POSSIBLE ENHANCEMENTS:  The program as written now leaves the temp
* databases once the program is done.  It could easily be enhanced
* to "clean-up" (delete) the temporary databases when done with them.
* It could also be configured to access multiple files, selectively
* enable/disable downloading, etc.  You could also make it return
* to the program after the download (it currently exits).
*



*
* make temporary database filename based on unique line number
*
myfile = "TR"+ULINE()+".DBF"

*
* if an old version of that file exists, delete it
*
if file(myfile)
    erase &myfile
endif

*
* create the database in real time
*
create newstruc
use newstruc
append blank
replace field_name with "FPOS", field_type with "N", field_len with 10
use
create &myfile from newstruc
erase newstruc.dbf

*
* use the database we just created
*
use &myfile

*
* look for filename in the opt data; it comes after the "&&"
*
offset = at(chr(38)+chr(38), optdata())
foobar = trim(substr(optdata(), offset + 3))


*
* set initial value for file position
*
pos = 0


*
* open the text file in read mode, and report an error if there was one
*
fopen handle (foobar) 10
if handle = -1
    ? "Error: "+MESSAGE(FERROR())
    ? "File was: ["+foobar+"]"
    wait
    quit
endif


*
* get the size of the file we're reading so we can display the
* percentage done
*
foosize = fsize(foobar)

*
* establish the initial value for a counter
*
counter = 1

*
* do initial screen prep
*
clear
set color to W+/R
@ 0,0 clear to 0,79
@ 0,1 say "Enhanced Text Reader - "+foobar

*
* get and store our initial file offset to our temp database
*
fseek handle pos 0
page = 1
append blank
replace FPOS with pos

*
* set colors for the text
*
set color to w/

*
* start a loop for our file processing
*
do while .t.
    *
    * if we've displayed 21 lines to the screen, it's time
    * for a pause
    *
    if counter = 21
        *
        * reset the counter
        *
        counter = 1

        *
        * get our current file offset, then calculate the percentage done
        *
        fseek handle moof 0
        percent = (moof * 100) / foosize


        *
        * display the prompt line and wait for input
        *
        ? ""
        ? "Page "+ltrim(str(page))+" ("+ltrim(str(percent))+"%)  <S>top, <P>revious Page, <D>ownload Text, <Enter> Continues."
        key = inkey(0)
        sel = upper(chr(key))

        *
        * handle the prompt line selection
        *

        if sel = "S"    && stop
            quit
        endif

        if sel = "P"    && previous page
            *
            * decrement our page counter (if possible) then goto that
            * record in our temp database
            *
            if page > 1
                page = page - 1
            endif
            goto page
            *
            * take the offset of that page, and move our pointer in the
            * text file there and then loop
            *
            fseek handle new FPOS 0
            @ 1,0 clear
            loop
        endif

        if sel = "D"    && download
            *
            * download then exit
            *
            dotbbs type 1 optdata foobar+" /D/NBC/NB"
            quit
        endif

        *
        * any other keypress gets us here, so assume next page
        * and handle it as such
        *
        @ 1,0 clear
        page = page + 1
        if reccount() < page
            fseek handle scratch 0
            append blank
            replace FPOS with scratch
        endif
        loop
    endif   && end of "if line count is 21"

    *
    * we're here if the line count is not 21
    *


    *
    * read a line from the file
    *
    flread handle count displ

    *
    * if we actually read any characters, display them and loop
    *
    if count # 0
        ? crtrim(displ)
        counter = counter + 1
        loop
    else
        *
        * we read no bytes, meaning we're at the end of the file
        * handle this case specially, in essence, duplicating what
        * we did above (refer to comments there)
        *
        ? ""
        ? "Page "+ltrim(str(page))+" (100%)  <S>top, <P>revious Page, <D>ownload Text, <Enter> Continues."
        key = inkey(0)
        sel = upper(chr(key))
        if sel = "D"
            dotbbs type 1 optdata foobar+" /D/NBC/NB"
            quit
        endif
        if sel = "P"
            if page > 1
                page = page - 1
            endif
            goto page
            fseek handle new FPOS 0
            counter = 1
            @ 1,0 clear
            loop
        endif
        quit
    endif
enddo

*
* if we're here, we're done, so close stuff and quit
*
fclose(handle)
quit
